# check-http-ssl

## Summary

This is a Python 3 script that checks the validity of SSL certificates for HTTPS hosts. It connects to the specified hosts, retrieves their SSL certificates, and reports how many days remain until expiration. The script provides warnings and critical alerts based on configurable thresholds.

## How It Works

The script performs the following steps:

1. **Connects to the HTTPS host** using Python's `ssl` and `socket` modules
2. **Retrieves the SSL certificate** from the server
3. **Extracts the expiration date** from the certificate's `notAfter` field
4. **Calculates days remaining** until expiration (using UTC time)
5. **Compares against thresholds** to determine status:
   - **OK**: Certificate is valid for at least the warning threshold (default: 14 days)
   - **WARNING**: Certificate expires within the warning threshold but more than the critical threshold (default: 7-13 days)
   - **CRITICAL**: Certificate expires within the critical threshold (default: <7 days)
   - **ERROR**: Connection, SSL, or other errors occurred

## Usage

### Single Host Check

Check a specific host by providing it as an argument:

```bash
./bin/check-http-ssl.py https://example.com
```

Or without the `https://` prefix (it will be added automatically):

```bash
./bin/check-http-ssl.py example.com
```

### Multiple Host Checks

The script can check multiple hosts in a single run. It determines which hosts to check using the following priority order:

1. **Command-line argument**: If a URL is provided as an argument, only that host is checked
2. **Sensu configuration**: If `/etc/sensu/agent.yml` exists and contains a `check-http-ssl-hosts` key, those hosts are checked
3. **Wisol configuration**: If `/opt/wisol-install/sites.yml` exists and contains a `sites` list, those sites are checked
4. **System hostname**: If none of the above are available, the script checks the system's hostname

### Configuration Files

#### Sensu Configuration (`/etc/sensu/agent.yml`)

The script reads threshold values and host list from the Sensu agent configuration file:

```yaml
ssl-warning-threshold: 14    # Days until expiration to trigger WARNING
ssl-critical-threshold: 7    # Days until expiration to trigger CRITICAL
check-http-ssl-hosts:       # List of hosts to check
  - example.com
  - another.example.com
```

#### Wisol Configuration (`/opt/wisol-install/sites.yml`)

The script can read a list of sites from the Wisol configuration file:

```yaml
sites:
  - site1.example.com
  - site2.example.com
```

## Exit Codes

The script uses standard monitoring exit codes:

- **0**: OK - All certificates are valid within thresholds
- **1**: WARNING - One or more certificates are expiring soon (within warning threshold)
- **2**: CRITICAL - One or more certificates are expiring very soon (within critical threshold)
- **3**: ERROR - Connection or SSL errors occurred (mapped to exit code 1 for compatibility)

When checking multiple hosts, the script exits with the worst status found across all checks.

## Output

### Successful Check (All Valid)

```
OK: 3 hosts checked and valid within threshold (14 days)
```

### Warning or Critical

```
WARNING: Certificate nearing expiration for 2 hosts
- example.com expires in 10 days
- another.com expires in 8 days
```

Or:

```
CRITICAL: Certificate nearing expiration for 1 host
- critical.example.com expires in 5 days
```

## Default Thresholds

- **Warning threshold**: 14 days (configurable via `ssl-warning-threshold` in `/etc/sensu/agent.yml`)
- **Critical threshold**: 7 days (configurable via `ssl-critical-threshold` in `/etc/sensu/agent.yml`)

## Requirements

- Python 3
- Standard library modules: `ssl`, `socket`, `sys`, `os`, `yaml`, `datetime`, `urllib.parse`
- PyYAML (for YAML configuration file parsing)

## Error Handling

The script handles various error conditions:

- **Invalid URLs**: Returns error message
- **DNS resolution failures**: Reports hostname resolution errors
- **Connection timeouts**: Reports timeout after 10 seconds
- **SSL errors**: Reports SSL/TLS connection errors
- **Missing certificate data**: Reports if expiration date cannot be retrieved

## Integration

This script is designed to work with monitoring systems like:

- **Nagios/Icinga**: Uses standard exit codes (0, 1, 2)
- **Sensu**: Can read configuration from `/etc/sensu/agent.yml`
- **Cron jobs**: Can be scheduled to run periodically

Example cron job to check certificates daily:

```cron
0 9 * * * /path/to/check-http-ssl.py
```
